using System;
using System.Collections;

using Team_Project.PersistencyManagers;
using Team_Project.PersistencyManagers.Storages;
using Team_Project.PersistencyManagers.Protocols;

namespace Team_Project
{
	/// <summary>
	/// Questa classe contiene (nella sua istanza singleton) le costanti necessarie al funzionamento del
	/// progetto.
	/// </summary>
	/// <remarks>Nel prototipo tali costanti sono cablate nel codice, mentre
	/// in un'implementazione commerciale sarebbero lette da file di configurazione,
	/// da database o in qualche altro modo.</remarks>
	public class Globals : MarshalByRefObject
	{
		/// <summary>
		/// Nome della copia locale.
		/// </summary>
		public string LocalCopyName = "SIMO";
		/// <summary>
		/// Tempo (in milli-secondi) dopo il quale scatta il time-out per le comunicazioni
		/// remote gestite in modo asincrono.
		/// </summary>
		public int TimeOut = 15000;
		/// <summary>
		/// Tempo (in milli-secondi) di attesa prima di ricontrollare lo stato dell'operazione
		/// asincrona
		/// </summary>
		public int PollTime = 10;
		/// <summary>
		/// Porta sulla quale  in attesa il servizio.
		/// </summary>
		public int ListenPort = 6112;

		private static Globals inst = null;

		/// <summary>
		/// Ottiene l'unica istanza di Globals
		/// </summary>
		public static Globals Instance
		{
			get
			{
				if (inst == null)
					inst = new Globals();
				return inst;
			}
		}

		/// <summary>
		/// Ottiene o imposta l'istanza globale del gestore di protocolli
		/// </summary>
		public ProtocolManager Protocols
		{
			get
			{
				if(Data["ProtocolManager"] == null)
				{
#if DEBUG
					Data["ProtocolManager"] = new ProtocolManager(@"..\..\..\Config\Protocols",true);
#else
					Data["ProtocolManager"] = new ProtocolManager(@"..\..\..\Config\Protocols",true);
#endif
				}
				return (ProtocolManager)Data["ProtocolManager"];
			}
			set
			{
				Data["ProtocolManager"] = value;
			}
		}

		private StorageManager srotages = null;
		/// <summary>
		/// Ottiene o imposta l'istanza globale del gestore degli storages
		/// </summary>
		public StorageManager Storages
		{
			get
			{
				if(srotages == null)
				{
					srotages = new StorageManager();
				}
				return srotages;
			}
			set
			{
				srotages = value;
			}
		}

		private TPEngine engine = null;
		/// <summary>
		/// Ottiene l'istanza dell'engine di team project
		/// </summary>
		public TPEngine Engine
		{
			get
			{
				return engine;
			}
			set
			{
				engine = value;
			}
		}

		private MutexHolder mutexes = null;
		/// <summary>
		/// Ottiene o imposta l'istanza globale del gestore del pool di mutex di sincronizzazione
		/// </summary>
		public MutexHolder Mutexes
		{
			get
			{
				if(mutexes == null)
				{
					mutexes = new MutexHolder();
				}
				return mutexes;
			}
			set
			{
				mutexes = value;
			}
		}

		/// <summary>
		/// HashTable degli oggetti globali. Questi oggetti vengono inseriti automaticamente
		/// all'avvio del servizio da parte dell'engine che si occupa anche della loro
		/// eventuale distruzione, ma pu essere utilizzato anche per contenere altri oggetti
		/// generati durante l'esecuzione normale del servizio
		/// </summary>
		public Hashtable Data = new Hashtable();
	}
}

